<?php
define( 'OPEN_THEME_VERSION', '1.4.2' );
define( 'OPEN_SETTING_DOMAIN', 'open' );

define( 'OPEN_DIR', wptouch_get_bloginfo( 'theme_root_directory' ) );
define( 'OPEN_URL', wptouch_get_bloginfo( 'theme_root_url' ) );

// Open actions
add_action( 'init', 'open_init' );
add_action( 'foundation_init', 'open_theme_init' );
add_action( 'foundation_modules_loaded', 'open_register_fonts' );
add_action( 'admin_enqueue_scripts', 'open_enqueue_admin_scripts' );

// Open filters
add_filter( 'wptouch_registered_setting_domains', 'open_setting_domain' );
add_filter( 'wptouch_setting_defaults', 'open_setting_defaults' );
add_filter( 'wptouch_setting_defaults_foundation', 'open_foundation_setting_defaults', 20 );
add_filter( 'wptouch_admin_page_render_wptouch-admin-theme-settings', 'open_theme_settings' );
add_filter( 'wptouch_admin_page_render_wptouch-admin-menus', 'open_menu_settings', 20 );
add_filter( 'wptouch_body_classes', 'open_body_classes' );

function open_setting_domain( $domain ) {
	$domain[] = OPEN_SETTING_DOMAIN;

	return $domain;
}

function open_get_settings() {
	return wptouch_get_settings( OPEN_SETTING_DOMAIN );
}

function open_setting_defaults( $settings ) {
	// Open menu default
	$settings->primary_menu = 'wp';

	$settings->tagline = '';

	// Theme colors
	$settings->open_header_color = '#b8d04a';
	$settings->header_image = '';
	$settings->open_branding_color = '#4a2f13';
	$settings->open_background_color = '#f5f0f0';
	$settings->open_link_color = '#098aa1';

	$settings->logo_background_field = true;

	// CTA
	$settings->show_cta = true;
	$settings->cta_label = 'Call Us To Book';
	$settings->cta_action = 'tel:1-905-555-1234';

	// Location
	$settings->map_address = false;

	// Hours
	$settings->show_hours = true;
	$settings->hours_sunday = '';
	$settings->hours_monday = '';
	$settings->hours_tuesday = '';
	$settings->hours_wednesday = '';
	$settings->hours_thursday = '';
	$settings->hours_friday = '';
	$settings->hours_saturday = '';
	$settings->hours_note = '';

	$settings->open_show_menu_on_homepage = true;

	return $settings;
}

function open_foundation_setting_defaults( $settings ) {
	$settings->typography_sets = 'patua_alegreya';
	return $settings;
}

function open_init() {
	$open_settings = open_get_settings();
	if ( $open_settings->show_hours || $open_settings->map_address ) {
		add_rewrite_tag('%open_feature%', '([a-z]+)');
	}
}

function open_theme_init() {
	// Foundation modules this theme should load
	foundation_add_theme_support(
		array(
			// Modules w/ settings
			'webapp',
			'custom-posts',
			'custom-latest-posts',
			'google-fonts',
			'media',
			'social-links',
			'menu',
			'wptouch-icons',
			'fastclick',
			'tappable',
			'spinjs',
			'advertising',
			'concat'
		)
	);

	wptouch_register_theme_menu(
		array(
			'name' => 'primary_menu',	// this is the name of the setting
			'friendly_name' => __( 'Primary Menu', 'wptouch-pro' ),	// the friendly name, shows as a section heading
			'settings_domain' => OPEN_SETTING_DOMAIN,	// the setting domain (should be the same for the whole theme)
			'description' => __( 'Choose a menu', 'wptouch-pro' ),	 	// the description
			'tooltip' => __( 'Menus are awesome!', 'wptouch-pro' ), // Extra help info about this menu, perhaps?
			'can_be_disabled' => false
		)
	);

	foundation_register_theme_color( 'open_branding_color', __( 'Main branding colour', 'wptouch-pro' ), '#header-area h1, .has-header-image #header-area h1.color, #menu-toggle',  '.wptouch-login-wrap, #openclosed, #switch .active', OPEN_SETTING_DOMAIN );
	foundation_register_theme_color( 'open_header_color', __( 'Header background', 'wptouch-pro' ), '', '#header-area', OPEN_SETTING_DOMAIN );
	foundation_register_theme_color( 'open_background_color', __( 'Theme background', 'wptouch-pro' ), '', '.page-wrapper', OPEN_SETTING_DOMAIN );
	foundation_register_theme_color( 'open_link_color', __( 'Links', 'wptouch-pro' ), 'a, .menu-tree li span::before', 'body, .dots li.active, .footer-action a', OPEN_SETTING_DOMAIN );
}

function open_menu_settings( $page_options ) {
	wptouch_add_page_section(
		WPTOUCH_ADMIN_MENU_ICONS_OPTIONS,
		__( 'Open Homepage Menu', 'wptouch-pro' ),
		'open_show_menu_on_homepage',
		array(
			wptouch_add_setting(
				'checkbox',
				'open_show_menu_on_homepage',
				__( 'Show full menu on Open homepage', 'wptouch-pro' ),
				__( 'If disabled, only Location & Hours links will be shown', 'wptouch-pro' ),
				WPTOUCH_SETTING_BASIC,
				'1.0'
			)
		),

		$page_options,
		OPEN_SETTING_DOMAIN
	);

	return $page_options;
}

function open_theme_settings( $page_options ) {
	wptouch_add_page_section(
		FOUNDATION_PAGE_BRANDING,
		__( 'Tagline', 'wptouch-pro' ),
		'tagline',
		array(
			wptouch_add_setting(
				'text',
				'tagline',
				__( 'Displayed below your logo on the homepage.', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			)
		),

		$page_options,
		OPEN_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		FOUNDATION_PAGE_BRANDING,
		__( 'Header Image', 'wptouch-pro' ),
		'header-image',
		array(
			wptouch_add_setting(
				'image-upload',
				'header_image',
				__( 'Displayed behind header on pages.', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			)
		),

		$page_options,
		OPEN_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		FOUNDATION_PAGE_BRANDING,
		__( 'Homepage Logo Background', 'wptouch-pro' ),
		'logo-background',
		array(
			wptouch_add_setting(
				'checkbox',
				'logo_background_field',
				__( 'Display a white background behind the site logo.', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			)
		),

		$page_options,
		OPEN_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		FOUNDATION_PAGE_GENERAL,
		__( 'Location', 'wptouch-pro' ),
		'location',
		array(
			wptouch_add_setting(
				'text',
				'map_address',
				__( 'Map address', 'wptouch-pro' ),
				__( 'Enter an address and a menu item for \'Our Location\' will be shown.', 'wptouch-pro' ),
				WPTOUCH_SETTING_BASIC,
				'1.0'
			)
		),

		$page_options,
		OPEN_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		FOUNDATION_PAGE_GENERAL,
		__( 'Call to Action', 'wptouch-pro' ),
		'call_to_action',
		array(
			wptouch_add_setting(
				'checkbox',
				'show_cta',
				__( 'Show call to action button at bottom of pages', 'wptouch-pro' ),
				__( 'Give visitors a one-click action to follow and increase your conversions.', 'wptouch-pro' ),
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'cta_label',
				__( 'Button Label', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'cta_action',
				__( 'Target URL', 'wptouch-pro' ),
				__( 'Prefix your phone number with "tel:" to allow one-click phone calls.', 'wptouch-pro' ),
				WPTOUCH_SETTING_BASIC,
				'1.0'
			)
		),

		$page_options,
		OPEN_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		FOUNDATION_PAGE_GENERAL,
		__( 'Hours', 'wptouch-pro' ),
		'hours',
		array(
			wptouch_add_setting(
				'checkbox',
				'show_hours',
				__( 'Use built-in Hours feature', 'wptouch-pro' ),
				__( 'Add your hours and the current day\'s hours will appear on the homepage along with a menu item for \'Our Hours\'.', 'wptouch-pro' ),
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'hours_sunday',
				__( 'Sunday', 'wptouch-pro' ),
				__( 'Will show as closed if left blank.', 'wptouch-pro' ),
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'hours_monday',
				__( 'Monday', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'hours_tuesday',
				__( 'Tuesday', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'hours_wednesday',
				__( 'Wednesday', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'hours_thursday',
				__( 'Thursday', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'hours_friday',
				__( 'Friday', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'text',
				'hours_saturday',
				__( 'Saturday', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'1.0'
			),
			wptouch_add_setting(
				'textarea',
				'hours_note',
				__( 'Note', 'wptouch-pro' ),
				__( 'Let visitors know about holidays, vacations, and other special hours', 'wptouch-pro' ),
				WPTOUCH_SETTING_BASIC,
				'1.0'
			)

		),

		$page_options,
		OPEN_SETTING_DOMAIN
	);

	return $page_options;
}

function open_enqueue_admin_scripts() {
	wp_enqueue_script(
		'open-admin-js',
		OPEN_URL . '/admin/open-admin.js',
		array( 'jquery', 'wptouch-pro-admin' ),
		OPEN_THEME_VERSION,
		false
	);
}

function open_body_classes( $classes ) {
	global $wp_query;
	// Pages with the open_feature rewrite default to 'home' & 'blog' - override.
	if ( isset( $wp_query->query_vars[ 'open_feature' ] ) ) {
		$classes = array_flip( $classes );
		unset( $classes[ 'blog' ] );
		unset( $classes[ 'home' ] );
		$classes = array_flip( $classes );
		$classes[] = $wp_query->query_vars[ 'open_feature' ];
		$classes[] = 'page';
	} elseif ( is_front_page() ) {
		$core_settings = wptouch_get_settings();
		if ( $core_settings->homepage_landing != 'none' ) {
			$classes = array_flip( $classes );
			unset( $classes[ 'home' ] );
			$classes = array_flip( $classes );
			$classes[] = $wp_query->query_vars[ 'open_feature' ];
			$classes[] = 'page';
		}
	}

	$settings = open_get_settings();

  	$link_luma = wptouch_hex_to_luma( $settings->open_link_color );

	if ( $link_luma <= 250 ) {
		$classes[] = 'dark-links';
	} else {
		$classes[] = 'light-links';
	}

	return $classes;
}

function open_register_fonts() {
	if ( foundation_is_theme_using_module( 'google-fonts' ) ) {
		foundation_register_google_font_pairing(
			'patua_alegreya',
			foundation_create_google_font( 'heading', 'Patua One', 'sans-serif', array( '400' ) ),
			foundation_create_google_font( 'body', 'Alegreya Sans', 'sans-serif', array( '300', '400', '700', '400italic', '700italic' ) )
		);
		foundation_register_google_font_pairing(
			'satisfy_lato',
			foundation_create_google_font( 'heading', 'Satisfy', 'sans-serif', array( '400' ) ),
			foundation_create_google_font( 'body', 'Lato', 'sans-serif', array( '300', '400', '700', '400italic', '700italic' ) )
		);
	}
}