<?php 
/**
 * Class SWP_Testimonial_Widget is to display widget.
*/
class SWP_Testimonial_Widget extends WP_Widget {

	function SWP_Testimonial_Widget(){
		parent::__construct(false,$name="Testimonial Widget",array('description'=>'Display Testimonials'));
	}
	/**
	 * Function widget() contains data to show on frontend.
	 * @param array $args of widget area.  
	 * @param array $instance current settings of widget.
	*/
	function widget($args,$instance){
		global $post;
		global $wp_query;
		extract($args);

		$widget_title = $instance['widget_title'];
		$posts = $instance['post_no'];
		$order = $instance['post_sorting'];
		$order_by = $instance['order_by'];
		$effect = $instance['effect'];
		$time = $instance['time'];
		$category = $instance['category_name'];
		$fields = $instance['fields'];
		$uniq ='_'.strtotime(date('D-m-Y')).'_'.rand(1,9999);
	?>
			<script type="text/javascript">
		    jQuery(document).ready(function($) {
		    	var effect = '<?php echo $effect; ?>';
		                if(effect != 'none')
		                {
		                    $('#testi_slider<?php echo $uniq; ?>').cycle({ 
		                        fx: effect, 
		                        timeout: '<?php echo $time; ?>'	                     
		                    }); 
		                }else{
		                	$('#testi_slider<?php echo $uniq; ?>').cycle({
		                		timeout: '<?php echo $time; ?>'
		                	});
		                }
		    });
		    </script>
		
		<?php 
		echo $before_widget; 
	
		if(!empty($widget_title)){ 
			echo $before_title.$widget_title.$after_title;
		} 
		?>
		<div class='content_display' id="testi_slider<?php echo $uniq; ?>">	
			<?php 
				$output_data = swpt_widget_shortcode_output($posts,$order,$order_by,$category,$fields);
				echo $output_data;
			?>
		</div>
		<?php 
		echo $after_widget; 
	}

	/**
	 * Function update() is to save inserted data.
	 * @param array $new_instance is to store updated values.
	 * @param array $old_instance contains old values.
	*/
	function update($new_instance,$old_instance){
		global $wpdb;
		
		$instance=$old_instance;
		$instance['widget_title'] = $new_instance['widget_title'];
		$instance['post_sorting'] = $new_instance['post_sorting'];
		$instance['order_by'] = $new_instance['order_by'];
		$instance['effect'] = $new_instance['effect'];
		$instance['category_name'] = $new_instance['category_name'];
		$instance['fields'] = $new_instance['fields'];

		if(!empty($new_instance['post_no']))
		{
			$postCount = $new_instance['post_no'];
		}
		else{
			$postCount = 1;
		}

		$instance['post_no']=$postCount;

		if(!empty($new_instance['time']))
		{
			$effectTime = $new_instance['time'];
		}
		else{
			$effectTime = 1000;
		}
		$instance['time']=$effectTime;

		if(!empty($new_instance['category_name']))
		{
			$category = $new_instance['category_name'];
		}
		else{
			$category = 'all';
		}

		if(!empty($new_instance['fields'])){
			$fields = implode(",",$new_instance['fields']);
		}
		$instance['fields']=$fields;
				
		return $instance;
	}

	/**
	 * Function form() displays form in the widget.
	 * @param array $instance current settings of widget.
	*/
	function form($instance) {
		global $wpdb;

		if(array_key_exists('widget_title', $instance)){
			$widget_title = $instance['widget_title'];
		}
		else{
			$widget_title = '';	
		}
		
		if(array_key_exists('post_sorting', $instance)){
			$order = $instance['post_sorting'];
		}
		else{
			$order = '';	
		}

		if(array_key_exists('category_name', $instance)){
			$category = $instance['category_name'];
		}
		else{
			$category = '';	
		}

		if(array_key_exists('fields', $instance)){
			$fields =  explode(",",$instance['fields']);
		}
		else{
			$fields = '';	
		}
		
		if(array_key_exists('order_by', $instance)){
			$order_by = $instance['order_by'];
		}
		else{
			$order_by = '';	
		}
		
		if(array_key_exists('effect', $instance)){
			$effect = $instance['effect'];
		}
		else{
			$effect = '';	
		}

		if(!empty($instance['post_no']))
		{
			$posts = $instance['post_no'];
		}
		else{
			$posts = 1;
		}
		
		if(!empty($instance['time']))
		{
			$time = $instance['time'];
		}
		else{
			$time = 1000;
		}
		?>
		<p>
			<label for="<?php echo  $this->get_field_id('widget_title'); ?>">Title</label>
			<input type="text" name="<?php echo $this->get_field_name('widget_title'); ?>" id="<?php echo $this->get_field_id('widget_title'); ?>" value="<?php echo $widget_title; ?>" class="widefat">
		</p>
		<p class="custom_widget_size">
			<label for="<?php echo $this->get_field_id('post_no'); ?>">Show</label>
			<input type="text" name="<?php echo $this->get_field_name('post_no'); ?>" id="<?php echo $this->get_field_id('post_no'); ?>" value="<?php echo $posts; ?>" >
		</p>
		<p class="custom_widget_size mrg-none">
			<label for="<?php echo $this->get_field_id('category_name'); ?>">Category </label>
			<select name="<?php echo $this->get_field_name('category_name'); ?>" id="<?php echo $this->get_field_id('category_name'); ?>">
				<option value="all">All</option>
				<?php $arrCats = getCategory(); ?>
				<?php foreach ($arrCats as $key => $value): ?>
				<option <?php if($category == $value['id']): ?> selected <?php endif; ?> value="<?php echo $value['id']; ?>"><?php echo $value['category_name']; ?></option>
				<?php endforeach ?>
			</select>
		</p>
		<p class="custom_widget_size ">
			<label for="<?php echo $this->get_field_id('post_sorting'); ?>">Order </label>
			<select name="<?php echo $this->get_field_name('post_sorting'); ?>" id="<?php echo $this->get_field_id('post_sorting'); ?>">
				<option value="asc" <?php if($order=='asc' || $order == "") { ?> selected=selected <?php } ?>>Ascending</option>
				<option value="desc" <?php if($order=='desc') { ?> selected=selected <?php } ?>>Descending</option>
			</select>
		</p>
		<p class="custom_widget_size mrg-none">
			<label for="<?php echo $this->get_field_id('order_by'); ?>">Order by </label>
			<select name="<?php echo $this->get_field_name('order_by'); ?>" id="<?php echo $this->get_field_id('order_by'); ?>">
				<option value="id" <?php if($order_by=='id' || $order_by == "") { ?> selected=selected <?php } ?>>ID</option>
				<option value="company" <?php if($order_by=='company') { ?> selected=selected <?php } ?>>Company</option>
				<option value="description" <?php if($order_by=='description') { ?> selected=selected <?php } ?>>Description</option>
			</select>
		</p>		
		<p class="custom_widget_size">
			<label for="<?php echo $this->get_field_id('effect'); ?>">Effect</label>
			<select name="<?php echo $this->get_field_name('effect'); ?>" id="<?php echo $this->get_field_id('effect'); ?>">
				<?php
					$arrEffect = array("blindX","blindY","blindZ","curtainY","fade","fadeZoom","growY","none","scrollUp","scrollDown","scrollLeft","scrollRight","scrollHorz","scrollVert","toss","turnUp","turnDown","zoom"); 
					foreach($arrEffect as $strKey => $strValue)
					{
				?>
				<option value="<?php echo $strValue; ?>" <?php if($effect==$strValue) { ?> selected=selected <?php } ?>><?php echo ucfirst($strValue); ?></option>
				<?php } ?>
			</select>
		</p>
		<p class="custom_widget_size mrg-none">
			<label for="<?php echo $this->get_field_id('time'); ?>">Effect Duration (ms)</label>
			<input type="text" name="<?php echo $this->get_field_name('time'); ?>" id="<?php echo $this->get_field_id('time'); ?>" value="<?php echo $time; ?>" size="5">
		</p>
		<p class="select-fields">
			<label>Select Fields To Show</label>
			<div class="checkbox-widget-group">
				<input type="checkbox" checked disabled  name="<?php echo $this->get_field_name('fields'); ?>" id="<?php echo $this->get_field_id('fields'); ?>1" value="description">
				<label for="fields">Testimonial</label>

				<input type="checkbox" <?php if(isset($fields) && (!empty($fields)) ): if(in_array("company",$fields)): ?>  checked <?php endif; else: ?> checked <?php endif; ?> name="<?php echo $this->get_field_name('fields'); ?>[]" id="<?php echo $this->get_field_id('fields'); ?>2" value="company" >
				<label for="<?php echo $this->get_field_id('fields'); ?>2">Company Name</label>

				<input type="checkbox" <?php if(isset($fields) && (!empty($fields)) ): if(in_array("client_name",$fields)): ?>  checked <?php endif; else: ?> checked <?php endif; ?> name="<?php echo $this->get_field_name('fields'); ?>[]" id="<?php echo $this->get_field_id('fields'); ?>3" value="client_name">
				<label for="<?php echo $this->get_field_id('fields'); ?>3">Author Name</label>

				<input type="checkbox" <?php if(isset($fields) && (!empty($fields)) ): if(in_array("client_desg",$fields)): ?>  checked <?php endif; else: ?> checked <?php endif; ?> name="<?php echo $this->get_field_name('fields'); ?>[]" id="<?php echo $this->get_field_id('fields'); ?>4" value="client_desg">
				<label for="<?php echo $this->get_field_id('fields'); ?>4">Designation</label>

				<input type="checkbox" <?php if(isset($fields) && (!empty($fields)) ): if(in_array("website",$fields)): ?>  checked <?php endif; else: ?> checked <?php endif; ?> name="<?php echo $this->get_field_name('fields'); ?>[]" id="<?php echo $this->get_field_id('fields'); ?>5" value="website">
				<label for="<?php echo $this->get_field_id('fields'); ?>5">Website</label>
				
				<input type="checkbox" <?php if(isset($fields) && (!empty($fields)) ): if(in_array("client_avtar",$fields)): ?>  checked <?php endif; else: ?> checked <?php endif; ?> name="<?php echo $this->get_field_name('fields'); ?>[]" id="<?php echo $this->get_field_id('fields'); ?>6" value="client_avtar">
				<label for="<?php echo $this->get_field_id('fields'); ?>6">Image</label>
			</div>
		</p>
		<?php
	}
}
?>