<?php
/**
 * Facebook Business Information
 *
 * Display Single Facebook Business using the Facebook Business API.
 * Only one business returned via this Facebook API.
 *
 * @api        : http://www.facebook.com/developers/documentation/v2/business
 */

$url = fbwp_like_button_url( $businesses[0] );

$x = 0;

// Set widget styles as defined by shortcode generator.
$css_class = 'facebook-widget-pro facebook-widget-business';
$css_style = '';

if ( 'left' === $instance['align'] || 'right' === $instance['align'] ) {
	$css_class .= ' facebook-widget-' . $instance['align'];
}

if ( ! empty( $instance['max_width'] ) ) {
	$css_style = 'max-width: ' . $instance['max_width'];
}
?>

<div id="fb-widget-<?php echo esc_attr( $instance['widget_id'] ); ?>"
     class="<?php echo esc_attr( $css_class ); ?>"
     style="<?php echo esc_attr( $css_style ); ?>"
>

	<?php
	/**
	 * Display Google Map ABOVE Results Option
	 */
	if ( $instance['google_map_position'] == 'above' || empty( $instance['google_map_position'] ) ) {
		include( 'map.php' );
	}

	/**
	 * Display Business information
	 * (if user has not checked or selected radio to not display)
	 */
	if (
		$instance['disable_business_info'] !== 'off'
		&& $instance['disable_business_info'] !== '1'
	) {
		include( 'business-info.php' );
	}

	/**
	 * Like Button (before reviews)
	 */
	if (
		isset( $instance['likebadge'], $instance['likebadge_position'] )
		&& 1 == $instance['likebadge']
		&& 'before' == $instance['likebadge_position']
	) {
		include( 'like-button.php' );
	}

	/**
	 * Display Reviews
	 */
	if ( '1' === $instance['display_reviews'] ) {
		echo fwp_reviews_inner( $instance, $businesses, $rating, $pagination );
	}

	/**
	 * Like Button (after reviews)
	 */
	if (
		isset( $instance['likebadge'], $instance['likebadge_position'] )
		&& 1 == $instance['likebadge']
		&& 'after' == $instance['likebadge_position']
	) {
		include( 'like-button.php' );
	}

	//Display Google Map BELOW Results Option
	if ( $instance['google_map_position'] === 'below' ) {
		include( 'map.php' );
	}
	?>
</div><!--/.facebook-business -->

