<?php

/**
 * Class Yellow_Pages_Reviews_Shortcode
 *
 * @description: Open Table Shortcode Class
 * @since      : 1.0
 */
class Yellow_Pages_Reviews_Shortcode extends Yellow_Pages_Reviews {

	/**
	 * Init shortcode
	 */
	function __construct() {

		parent::__construct();

		add_shortcode( 'yellow-pages-reviews', array( $this, 'handle_shortcode' ) );

	}

	function handle_shortcode( $atts ) {

		//Defaults shortcode vals
		$defaults = array(
			'title'              => '',
			'id'                 => '',
			'align'              => 'none',
			'max_width'          => '250px',
			'pre_content'        => '',
			'post_content'       => '',
			'cache'              => 'None',
			'hide_header'        => '',
			'hide_out_of_rating' => '',
			'no_follow'          => '1',
			'target_blank'       => '1',
			'widget_style'       => 'Minimal Light',
			'review_limit'       => '5',
			'review_filter'      => '',
		);

		//extract shortcode arguments
		extract( shortcode_atts( $defaults, $atts ) );

		//declare variables
		$args = $instance = array();

		//loop through options array and save variables for usage within function

		$globals = array(
			'title'              => empty( $atts['title'] ) ? $title : $atts['title'],
			'listing_id'         => empty( $atts['id'] ) ? $id : $atts['id'],
			'align'              => empty( $atts['align'] ) ? $align : $atts['align'],
			'max_width'          => empty( $atts['max_width'] ) ? $max_width : $atts['max_width'],
			'pre_content'        => empty( $atts['pre_content'] ) ? $pre_content : $atts['pre_content'],
			'post_content'       => empty( $atts['post_content'] ) ? $post_content : $atts['post_content'],
			'hide_header'        => empty( $atts['hide_header'] ) ? $hide_header : $this->check_shortcode_value( $atts['hide_header'] ),
			'hide_out_of_rating' => empty( $atts['hide_out_of_rating'] ) ? $hide_out_of_rating : $this->check_shortcode_value( $atts['hide_out_of_rating'] ),
			'cache'              => empty( $atts['cache'] ) ? $cache : $atts['cache'],
			'no_follow'          => empty( $atts['no_follow'] ) ? $no_follow : $atts['no_follow'],
			'target_blank'       => empty( $atts['target_blank'] ) ? $no_follow : $atts['target_blank'],
			'widget_style'       => empty( $atts['widget_style'] ) ? $widget_style : $atts['widget_style'],
			'review_limit'       => empty( $atts['review_limit'] ) ? $review_limit : $atts['review_limit'],
			'review_filter'      => empty( $atts['review_filter'] ) ? $review_filter : $atts['review_filter'],

		);

		//merge instance with globals
		$instance = array_merge( $instance, $globals );

		// actual shortcode handling here
		//Using ob_start to output shortcode within content appropriately
		ob_start();
		parent::widget( $args, $instance );
		$widget = ob_get_contents();
		ob_end_clean();

		/* Max Width (adds inline style) */
		$max_width = isset( $max_width ) ? ' style="max-width:' . $max_width . ';"' : '';
		$align     = isset( $align ) ? 'ypr-widget-align-' . $align . '' : '';
		$style     = "ypr-" . sanitize_title( $widget_style ) . "-style";

		//Wrap widget with ID for styling purposes
		$widget = '<div id="ypr_widget" ' . $max_width . ' class="' . $align . ' ' . $style . '">' . $widget . '</div>';

		//Output our Widget
		return $widget;

	}

	/*
	 * Check Value
	 *
	 * Helper Function
	 */
	function check_shortcode_value( $attr ) {

		if ( $attr === "true" || $attr === "1" || $attr == "yes" ) {
			$attr = "1";
		} else {
			$attr = '0';
		}

		return $attr;

	}

}