<?php
/**
 * FB Widget Form
 *
 * Widget form options in WP-Admin
 */
$settings = get_option( 'fb_widget_settings' );
?>

<!-- Title -->
<p>
    <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Widget Title', 'facebook-reviews-pro' ); ?>
        :<?php echo fbw_admin_tooltip( 'title' ); ?></label>
    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
           name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"
           value="<?php echo $instance['title']; ?>"/>
</p>

<!-- Listing Options -->

<div class="toggle-api-option-2 toggle-item toggled">
    <!-- Business ID -->
    <p>
        <label for="<?php echo $this->get_field_id( 'id' ); ?>"><?php
			esc_html_e( 'Business Page:', 'facebook-reviews-pro' );
			echo fbw_admin_tooltip( 'id' ); ?></label>
        <select class="widefat" id="<?php echo $this->get_field_id( 'id' ); ?>"
                name="<?php echo $this->get_field_name( 'id' ); ?>">
			<?php
			$page_tokens = json_decode( $settings['fb_widget_page_tokens'] );
			foreach ( $page_tokens as $page_token ) {
				echo '<option value="' . $page_token->id . '" ' . ( $instance['id'] == $page_token->id ? 'selected="selected"' : '' ) . '>' . $page_token->name . '</option>';
			}
			?>
        </select>
    </p>

    <p class="facebook-pages-reload"><?php esc_attr_e( 'Pages not showing?', 'facebook-reviews-pro' ); ?>
        <a href="<?php echo admin_url( 'options-general.php?page=facebook-reviews-pro' ); ?>"><?php esc_attr_e( 'Reload Pages', 'facebook-reviews-pro' ); ?></a> <?php esc_attr_e( 'in Settings', 'facebook-reviews-pro' ); ?>
    </p>

	<?php
	/**
	 * Like Badge Option.
	 */
	?>
    <p>
        <input id="<?php echo $this->get_field_id( 'likebadge' ); ?>"
               name="<?php echo $this->get_field_name( 'likebadge' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['likebadge'] ); ?> class="fb-like-button"/>
        <label for="<?php echo $this->get_field_id( 'likebadge' ); ?>"><?php esc_html_e( 'Display Like Button', 'facebook-reviews-pro' );
			echo fbw_admin_tooltip( 'likebadge' ); ?></label>
    </p>

	<?php
	/**
	 * Like Badge Location.
	 */
	?>
    <p <?php if ( ! isset( $instance['likebadge'] ) || 0 == $instance['likebadge'] ) : echo 'aria-hidden="true" style="display: none;"'; endif; ?>
            class="likebadge-wrap">
        <label for="<?php echo $this->get_field_id( 'likebadge_position' ); ?>">
			<?php esc_html_e( 'Show like button before or after reviews?', 'facebook-reviews-pro' ); ?>
        </label>

        <select id="<?php echo $this->get_field_id( 'likebadge_position' ); ?>"
                name="<?php echo $this->get_field_name( 'likebadge_position' ); ?>" class="fb-like-button-area">
            <option value="before" <?php if ( isset( $instance['likebadge_position'] ) && 'before' == $instance['likebadge_position'] ) : echo 'selected'; endif; ?> >
				<?php esc_html_e( 'Before', 'facebook-reviews-pro' ); ?>
            </option>
            <option value="after" <?php if ( isset( $instance['likebadge_position'] ) && 'after' == $instance['likebadge_position'] ) : echo 'selected'; endif; ?> >
				<?php esc_html_e( 'After', 'facebook-reviews-pro' ); ?>
            </option>
        </select>
    </p>


	<?php
	/**
	 * Display Reviews Option.
	 */
	?>
    <p>
        <input id="<?php echo $this->get_field_id( 'display_reviews' ); ?>" class="reviews-toggle"
               name="<?php echo $this->get_field_name( 'display_reviews' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['display_reviews'] ); ?>/>
        <label for="<?php echo $this->get_field_id( 'display_reviews' ); ?>"><?php esc_html_e( 'Display Business Reviews', 'facebook-reviews-pro' ); ?></label>
    </p>

    <div class="reviews-toggle-container <?php if ( $instance['display_reviews'] == '1' ) {
		echo 'toggled';
	} ?>">

        <h4 class="facebook-toggler"><?php _e( 'Review Options:', 'facebook-reviews-pro' ); ?><span></span></h4>

        <div class="display-options toggle-item">

            <!-- Filter Reviews -->
            <p>
                <label for="<?php echo $this->get_field_id( 'review_filter' ); ?>"><?php _e( 'Minimum Review Rating', 'facebook-reviews-pro' ); ?>
                    :<?php echo fbw_admin_tooltip( 'review_filter' ); ?></label>

                <select id="<?php echo $this->get_field_id( 'review_filter' ); ?>" class="widefat"
                        name="<?php echo $this->get_field_name( 'review_filter' ); ?>">

                    <option value="none" <?php if ( empty( $instance['review_filter'] ) || $instance['review_filter'] == 'No filter' ) {
						echo "selected='selected'";
					} ?>><?php _e( 'No filter', 'facebook-reviews-pro' ); ?>
                    </option>
                    <option value="5" <?php if ( $instance['review_filter'] == '5' ) {
						echo "selected='selected'";
					} ?>><?php _e( '5 Stars', 'facebook-reviews-pro' ); ?>
                    </option>
                    <option value="4" <?php if ( $instance['review_filter'] == '4' ) {
						echo "selected='selected'";
					} ?>><?php _e( '4 Stars', 'facebook-reviews-pro' ); ?>
                    </option>
                    <option value="3" <?php if ( $instance['review_filter'] == '3' ) {
						echo "selected='selected'";
					} ?>><?php _e( '3 Stars', 'facebook-reviews-pro' ); ?>
                    </option>
                    <option value="2" <?php if ( $instance['review_filter'] == '2' ) {
						echo "selected='selected'";
					} ?>><?php _e( '2 Stars', 'facebook-reviews-pro' ); ?>
                    </option>
                    <option value="1" <?php if ( $instance['review_filter'] == '1' ) {
						echo "selected='selected'";
					} ?>><?php _e( '1 Star', 'facebook-reviews-pro' ); ?>
                    </option>

                </select>

            </p>

            <!-- Review Limit -->
            <p>
                <label for="<?php echo $this->get_field_id( 'review_limit' ); ?>">
					<?php esc_html_e( 'Reviews Per Page (max 25):', 'facebook-widget-reviews' ); ?><?php echo fbw_admin_tooltip( 'review_limit' ); ?>
                </label><br/>
                <input name="<?php echo esc_attr( $this->get_field_name( 'review_limit' ) ); ?>"
                       id="<?php echo esc_attr( $this->get_field_id( 'review_limit' ) ); ?>"
                       value="<?php echo intval( $instance['review_limit'] ); ?>" type="number" min="1" max="25">
            </p>

            <!-- Reviews Height -->
            <p class="widget-height-field">
                <label for="<?php echo $this->get_field_id( 'reviews_height' ); ?>"
                       style="display: block;"><?php _e( 'Review Container Height:', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'reviews_height' ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'reviews_height' ) ); ?>"
                       name="<?php echo esc_attr( $this->get_field_name( 'reviews_height' ) ); ?>"
                       value="<?php echo empty( $instance['reviews_height'] ) ? '500' : intval( $instance['reviews_height'] ); ?>"
                       type="number" min="0"
                       style="width: 80px; clear:both;">

                <label for="<?php echo $this->get_field_id( 'reviews_height_value' ); ?>"
                       style="display: none;"><?php _e( 'Review Height Value:', 'facebook-reviews-pro' ); ?></label>
                <select name="<?php echo $this->get_field_name( 'reviews_height_value' ); ?>"
                        id="<?php echo $this->get_field_id( 'reviews_height_value' ); ?>" class="widefat"
                        style="width:auto; display: inline-block; margin-top:-2px;">
                    <option value="px"
						<?php if (
							! isset( $instance['reviews_height_value'] )
							|| empty( $instance['reviews_height_value'] )
							|| 'px' === $instance['reviews_height_value']
						) {
							echo 'selected="selected"';
						} ?>><?php esc_html_e( 'pixels (px)', 'facebook-reviews-pro' ); ?></option>
                    <option value="%"
						<?php if (
							isset( $instance['reviews_height_value'] )
							&& '%' === $instance['reviews_height_value']
						) {
							echo 'selected="selected"';
						} ?>><?php esc_html_e( 'percent (%)', 'facebook-reviews-pro' ); ?></option>
                </select>
            </p>

            <!-- Disable rating and time output -->
            <p>
                <input id="<?php echo $this->get_field_id( 'hide_rating' ); ?>"
                       name="<?php echo $this->get_field_name( 'hide_rating' ); ?>" type="checkbox"
                       value="1" <?php checked( '1', $instance['hide_rating'] ); ?>/>
                <label for="<?php echo $this->get_field_id( 'hide_rating' ); ?>"><?php _e( 'Hide Star Rating and Date', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'hide_rating' ); ?></label>
            </p>
            <!-- Disable ratings without text -->
            <p>
                <input id="<?php echo $this->get_field_id( 'hide_blank_rating' ); ?>"
                       name="<?php echo $this->get_field_name( 'hide_blank_rating' ); ?>" type="checkbox"
                       value="1" <?php checked( '1', $instance['hide_blank_rating'] ); ?>/>
                <label for="<?php echo $this->get_field_id( 'hide_blank_rating' ); ?>"><?php _e( 'Hide Blank Reviews', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'hide_blank_rating' ); ?></label>
            </p>

        </div>

    </div>

</div>


<h4 class="facebook-toggler"><?php _e( 'Display Options:', 'facebook-reviews-pro' ); ?><span></span></h4>

<div class="display-options toggle-item">

    <!-- Disable Business Info -->
    <p class="disable-business-info-field">
		<?php esc_html_e( 'Display Business Information:', 'facebook-reviews-pro' );
		echo fbw_admin_tooltip( 'disable_business_info' ) ?><br>
        <label for="<?php echo $this->get_field_id( 'disable_business_info' ); ?>" style="margin-right:10px;">
            <input name="<?php echo $this->get_field_name( 'disable_business_info' ); ?>"
                   value="on"
                   type="radio" <?php echo ( 'on' == $instance['disable_business_info'] ) ?  'checked data-selected="true"'
            : 'data-selected="false"'; ?>
                   id="<?php echo $this->get_field_id( 'disable_business_info' ); ?>"/>
			<?php _e( 'Show', 'facebook-reviews-pro' ); ?>
        </label>

        <label for="<?php echo $this->get_field_id( 'disable_business_info' ) . '_hide'; ?>">
            <input name="<?php echo $this->get_field_name( 'disable_business_info' ); ?>"
                   value="off"
                   type="radio" <?php echo ( 'on' != $instance['disable_business_info'] ) ? 'checked data-selected="true"'
			 : 'data-selected="false"'; ?>
                   id="<?php echo $this->get_field_id( 'disable_business_info' ) . '_hide'; ?>"/>
			<?php _e( 'Hide', 'facebook-reviews-pro' ); ?>
        </label>
    </p>

    <!-- Profile Image Size -->
    <p class="display-options-field">
        <label for="<?php echo $this->get_field_id( 'profile_img_size' ); ?>"><?php _e( 'Business Profile Image Size:', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'profile_img_size' ); ?></label>
        <select name="<?php echo $this->get_field_name( 'profile_img_size' ); ?>"
                id="<?php echo $this->get_field_id( 'profile_img_size' ); ?>" class="widefat">
			<?php
			$options = array( '40x40', '60x60', '80x80', '100x100' );
			foreach ( $options as $option ) {
				?>
                <option value="<?php echo $option; ?>"
                        id="<?php echo $option; ?>" <?php if ( $instance['profile_img_size'] == $option || empty( $instance['profile_img_size'] ) && $option == '60x60' ) {
					echo 'selected="selected"';
				} ?>><?php echo $option; ?></option>
			<?php } ?>
        </select>
    </p>
    <!-- Disable title output checkbox -->
    <p class="display-options-field">
        <input id="<?php echo $this->get_field_id( 'display_address' ); ?>"
               name="<?php echo $this->get_field_name( 'display_address' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['display_address'] ); ?>/>
        <label for="<?php echo $this->get_field_id( 'display_address' ); ?>"><?php esc_html_e( 'Display Business Address', 'facebook-reviews-pro' ); ?></label>
    </p>

    <p class="display-options-field">
        <input id="<?php echo $this->get_field_id( 'display_phone' ); ?>"
               name="<?php echo $this->get_field_name( 'display_phone' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['display_phone'] ); ?>/>
        <label for="<?php echo $this->get_field_id( 'display_phone' ); ?>"><?php _e( 'Display Business Phone Number', 'facebook-reviews-pro' ); ?></label>
    </p>
    <!-- Display phone -->


</div>

<h4 class="facebook-toggler"><?php _e( 'Google Map Options:', 'facebook-reviews-pro' ); ?><span></span></h4>

<div class="advanced-options toggle-item">

    <!-- Display Google Map checkbox -->
    <p>
        <input id="<?php echo $this->get_field_id( 'display_google_map' ); ?>"
               name="<?php echo $this->get_field_name( 'display_google_map' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['display_google_map'] ); ?>/>
        <label for="<?php echo $this->get_field_id( 'display_google_map' ); ?>"><?php _e( 'Display Google Map', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'display_google_map' ) ?></label>
    </p>


    <!-- Google Map Scrollability -->
    <p>
        <input id="<?php echo $this->get_field_id( 'disable_map_scroll' ); ?>"
               name="<?php echo $this->get_field_name( 'disable_map_scroll' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['disable_map_scroll'] ); ?>/>
        <label for="<?php echo $this->get_field_id( 'disable_map_scroll' ); ?>"><?php _e( 'Disable Map Scroll', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'disable_map_scroll' ) ?></label>
    </p>


    <!--- Google Map Position -->
    <p>
        <label id="<?php echo $this->get_field_id( 'google_map_position' ); ?>"
               for="<?php echo $this->get_field_id( 'google_map_position' ); ?>"
               class="fwp-radio-label"><?php _e( 'Map Position', 'facebook-reviews-pro' ); ?>:</label>
        <label><input type="radio" name="<?php echo $this->get_field_name( 'google_map_position' ); ?>"
                      value="above" <?php checked( 'above', $instance['google_map_position'] );
			if ( empty( $instance['google_map_position'] ) ) {
				echo "checked='checked'";
			} ?>><span
                    class="facebook-method-label"><?php _e( 'Above Results', 'facebook-reviews-pro' ); ?></span></label>
        <br>
        <label><input type="radio" name="<?php echo $this->get_field_name( 'google_map_position' ); ?>"
                      value="below" <?php checked( 'below', $instance['google_map_position'] ); ?>><span
                    class="facebook-method-label"><?php _e( 'Below Results', 'facebook-reviews-pro' ); ?></span>

    </p>


</div>


<h4 class="facebook-toggler"><?php esc_html_e( 'Advanced Options:', 'facebook-reviews-pro' ); ?><span></span></h4>

<div class="advanced-options toggle-item">

    <!-- Transient / Cache -->
    <p>
        <label for="<?php echo $this->get_field_id( 'cache' ); ?>"><?php _e( 'Cache Data', 'facebook-reviews-pro' ); ?>
            :<?php echo fbw_admin_tooltip( 'cache' ); ?></label>

        <select name="<?php echo $this->get_field_name( 'cache' ); ?>"
                id="<?php echo $this->get_field_id( 'cache' ); ?>" class="widefat">
			<?php $options = fbw_get_widget_cache_options();
			/**
			 * Output Cache Options (set 2 Days as default for new widgets)
			 */
			foreach ( $options as $option ) { ?>
                <option value="<?php echo $option; ?>"
                        id="<?php echo $option; ?>" <?php if ( $instance['cache'] == $option || ( empty( $instance['cache'] ) && $option == '1 Day' ) ) {
					echo ' selected="selected" ';
				} ?>>
					<?php echo $option; ?>
                </option>
			<?php } ?>
        </select>


    </p>

    <!-- Clear Cache Button -->
    <p class="clearfix">
        <span class="cache-message"></span>
        <a href="#" class="button fwp-clear-cache" title="Clear"
           data-transient-id="<?php echo $transient; ?>"><?php esc_html_e( 'Clear Cache', 'facebook-reviews-pro' ); ?></a>
        <span class="cache-clearing-loading spinner"></span>
    </p>


    <!-- Disable title output checkbox -->
    <p>
        <input id="<?php echo $this->get_field_id( 'disable_title_output' ); ?>"
               name="<?php echo $this->get_field_name( 'disable_title_output' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['disable_title_output'] ); ?>/>
        <label for="<?php echo $this->get_field_id( 'disable_title_output' ); ?>"><?php _e( 'Disable Title Output', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'disable_title_output' ); ?></label>
    </p>

    <!-- Open Links in New Window -->
    <p>
        <input id="<?php echo $this->get_field_id( 'target_blank' ); ?>"
               name="<?php echo $this->get_field_name( 'target_blank' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['target_blank'] ); ?> />
        <label for="<?php echo $this->get_field_id( 'target_blank' ); ?>"><?php _e( 'Open Links in New Window', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'target_blank' ); ?></label>
    </p>
    <!-- No Follow Links -->
    <p>
        <input id="<?php echo $this->get_field_id( 'no_follow' ); ?>"
               name="<?php echo $this->get_field_name( 'no_follow' ); ?>" type="checkbox"
               value="1" <?php checked( '1', $instance['no_follow'] ); ?> />
        <label for="<?php echo $this->get_field_id( 'no_follow' ); ?>"><?php _e( 'No Follow Links', 'facebook-reviews-pro' ); ?><?php echo fbw_admin_tooltip( 'no_follow' ); ?></label>
    </p>


</div>

<p class="fwp-widget-footer-links">
    <a href="https://wordimpress.com/documentation/facebook-reviews-pro/" target="_blank"
       class="new-window"><?php _e( 'Plugin Documentation', 'facebook-reviews-pro' ); ?></a>
    <a href="https://wordimpress.com/support/forum/facebook-reviews-pro/" target="_blank"
       class="new-window"><?php _e( 'Priority Support', 'facebook-reviews-pro' ); ?></a>
</p>
